<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model\Plugin;

use Magento\OutOfProcessPaymentMethods\Api\OutOfProcessPaymentMethodRepositoryInterface;
use Magento\OutOfProcessPaymentMethods\Api\PaymentMethodAdapterInterface;
use Magento\OutOfProcessPaymentMethods\Model\Helper\Data as PaymentMethodHelper;
use Magento\Payment\Helper\Data as PaymentHelper;

class AddOutOfProcessPaymentMethod
{
    /**
     * @param OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository
     * @param PaymentMethodHelper $paymentMethodHelper
     */
    public function __construct(
        private readonly OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository,
        private readonly PaymentMethodHelper                          $paymentMethodHelper
    ) {
    }

    /**
     * Intercepts instance retrieval to supply configurable payment method instance if needed.
     * Note "after" plugin can't be used because the intercepted method throws an exception when given code is
     * not found which avoids the execution of subsequent plugins.
     *
     * @param PaymentHelper $paymentHelper
     * @param callable $proceed
     * @param string $code
     * @return PaymentMethodAdapterInterface
     */
    public function aroundGetMethodInstance(PaymentHelper $paymentHelper, callable $proceed, string $code)
    {
        if ($this->paymentMethodHelper->isOutOfProcess($code)) {
            return $this->paymentMethodHelper->getInstance($code);
        }
        return $proceed($code);
    }

    /**
     * Adds the configurable payment methods to the original list
     *
     * @param PaymentHelper $paymentHelper
     * @param mixed $result
     * @return array
     */
    public function afterGetPaymentMethods(PaymentHelper $paymentHelper, mixed $result): array
    {
        foreach ($this->paymentMethodRepository->getList() as $paymentMethod) {
            $result[$paymentMethod->getCode()] = $paymentMethod;
        }
        return $result;
    }
}
