<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model\Helper;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Model\StoreManagerInterface;

class Store
{

    /**
     * Store constructor.
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(private readonly StoreManagerInterface $storeManager)
    {
    }

    /**
     * Get stores by array of ids.
     *
     * @param array $ids
     * @return array
     * @throws NoSuchEntityException
     */
    public function getById(array $ids): array
    {
        $ret = [];
        $stores = $this->storeManager->getStores();
        foreach ($ids as $storeId) {
            if (!array_key_exists($storeId, $stores)) {
                throw new NoSuchEntityException(__('Store id \'%1\' not found.', $storeId));
            }
            $ret[] = $stores[$storeId];
        }
        return $ret;
    }

    /**
     * Get stores by array of codes.
     *
     * @param array $codes
     * @return array
     * @throws NoSuchEntityException
     */
    public function getByCode(array $codes): array
    {
        $ret = [];
        $stores = $this->getAllStoresByCode();
        foreach ($codes as $storeCode) {
            if (!array_key_exists($storeCode, $stores)) {
                throw new NoSuchEntityException(__('Store code \'%1\' not found.', $storeCode));
            }
            $ret[] = $stores[$storeCode];
        }
        return $ret;
    }

    /**
     * Get all stores by code.
     *
     * @return array
     */
    public function getAllStoresByCode(): array
    {
        return array_reduce($this->storeManager->getStores(), function (array $stores, StoreInterface $store) {
            $stores[$store->getCode()] = $store;
            return $stores;
        }, []);
    }
}
