# Out Of Process Payment Methods

This module provides a way to configure Out Of Process (OOPE) Payments. All communication with payment providers is facilitated through an AppBuilder application.
A starter kit for creating an AppBuilder application is available [here](https://github.com/adobe/commerce-checkout-starter-kit).

## Local Development

To set up a local Magento development environment, please follow the instructions in the [local development guide](https://git.corp.adobe.com/commerce-services/magento-docker-environment/tree/main/extensions/oope-payment-methods).

## REST APIs

REST API definitions can be found in the [`etc/webapi.xml`](./etc/webapi.xml) file.
For testing, you can create OOPE payment methods using the HTTP client samples provided in the [`http-client` directory](./http-client).

### Available Endpoints:

Please ensure that all available endpoints are documented in the [Commerce Checkout Starter Kit](https://github.com/adobe/commerce-checkout-starter-kit/blob/main/README.md#commerce-api-methods).

| **Route URL**                                                                                                                                   | **Method** | **Description**                              |
| ----------------------------------------------------------------------------------------------------------------------------------------------- | ---------- | -------------------------------------------- |
| [`/V1/oope_payment_method/:code`](https://github.com/adobe/commerce-checkout-starter-kit?tab=readme-ov-file#get-an-oope-payment-method-by-code) | GET        | Retrieve an OOPE payment method by its code. |
| [`/V1/oope_payment_method`](https://github.com/adobe/commerce-checkout-starter-kit?tab=readme-ov-file#list-all-payment-methods)                 | GET        | List all available OOPE payment methods.     |
| [`/V1/oope_payment_method`](https://github.com/adobe/commerce-checkout-starter-kit?tab=readme-ov-file#create-a-new-oope-payment-method)         | POST       | Create or update an OOPE payment method.     |

## GraphQL Queries

The GraphQL schema for this is defined in [`etc/schema.graphqls`](./etc/schema.graphqls).
Once OOPE payment methods are created, they can be accessed using the `oopePaymentMethods` GraphQL query available in `available_payment_methods` or `selected_payment_method` of cart API.

For more information on extending the OOPE GraphQL schema, refer to the [EDS Integration Guide](https://github.com/adobe/commerce-checkout-starter-kit/blob/main/EDS.md#extend-oope-graphql-schema).

### Example Query:

```graphql
query getCart($cartId: String!) {
  cart(cart_id: $cartId) {
    ...CHECKOUT_DATA_FRAGMENT
  }
}

fragment CHECKOUT_DATA_FRAGMENT on Cart {
  id
  available_payment_methods {
    code
    title
    oope_payment_method_config {
      backend_integration_url
      custom_config {
        ... on CustomConfigKeyValue {
          key
          value
        }
      }
    }
  }
  selected_payment_method {
    code
    title
    oope_payment_method_config {
      backend_integration_url
      custom_config {
        ... on CustomConfigKeyValue {
          key
          value
        }
      }
    }
  }
}
```

### Example Response:

```json
{
  "available_payment_methods": [
    {
      "code": "checkmo",
      "title": "Check / Money order",
      "oope_payment_method_config": null
    },
    {
      "code": "oope_adyen",
      "title": "OOPE Adyen",
      "oope_payment_method_config": {
        "backend_integration_url": "http://oope-payment-method.pay/event",
        "custom_config": [
          {
            "key": "can_refund",
            "value": "true"
          }
        ]
      }
    }
  ],
  "selected_payment_method": {
    "code": "checkmo",
    "title": "Check / Money order",
    "oope_payment_method_config": null
  }
}
```

## CI/CD

_This section is a summary of the information contained in [this doc](https://wiki.corp.adobe.com/pages/viewpage.action?pageId=2610724362#CI/CDPipelinehowto-Howthepipelineworks), check for details._

This [Jenkins pipeline](https://cext.ci.corp.adobe.com/job/OOPE/job/oope-payment-methods/) builds and deploys the `oope-payment-methods` Magento extension.

Some initial considerations:

- Magento extensions are hosted in github.com, as our Jenkins is hosted in corp network it can't receive external webhook events. To solve this, we reverse the communication by polling the extension repo from Jenkins every minute.
- This is not a multibranch pipeline, it will only be triggered for main branch.
- Every time we release a new version we must update `BuildVersion` and `BuildBranch` in [ops/version-setter/config.json](ops/version-setter/config.json). That's the version number for the release to prod, for QA the version-setter will add new "alpha" suffixes for that version.

What this pipeline does:

- Publish a new artifact to the internal composer repository (connect20).
- Deploy that artifact to the QA Magento Cloud environment.
- Create a new tag from the commit that triggered the build.

#### Deploy hotfix/patch

1. Create a PR with the hotfix/patch, it must increase the patch version number for `BuildVersion` and `BuildBranch` in [ops/version-setter/config.json](ops/version-setter/config.json).
2. Merge the PR into main to trigger the pipeline, which will follow the usual process to build a unique, internal versioned artifact, upload it to the internal composer repository (connect20) and deploy it into our "QA" Magento Cloud Environment.
3. Run again the pipeline manually to promote that artifact (see next section).

#### Promote to prod

When promoting an artifact, say `1.2.3-alpha4`, we will rebuild that artifact without the "alpha" suffix and publish it to the [public composer repo](https://repo.magento.com/).

1. Run the Jenkins job manually with `PROMOTED_BUILD` set to the version we want to promote, e.g., `1.2.3-alpha4`.
2. Find the release in the [package repository admin UI](https://repo.magento.com/admin/packagist/web/ceeerelease/list) and add the `External` availability group to make it public.
3. Bump the `buildVersion` and `buildBranch` fields in [config.json](ops/version-setter/config.json) to the next release version in a version bump commit.
4. Create a release in github describing the changes.
5. Write a msg in #commerce-team-party-parrots announcing the new release:
   ```
   :mega: :adobe_commerce_02: `magento/module-out-of-process-payment-methods:0.1.1` released to repo.magento.com
   Release notes: https://github.com/magento-commerce/oope-payment-methods/releases/tag/0.1.1
   ```
