Configurable Payments for Adobe Commerce 
========================================

Provides a way to configure Out Of Process Payments. All communication with payment providers should be done in a AppBuilder application. Refer to proper Starter Kit.



# Configuration

The way to configure a new payment method is through REST API. 

## Adding a new payment method

```
POST {{commerce.base_url}}/rest/all/V1/oope_payment_method
accept: application/json
Content-Type: application/json
Authorization: Bearer {{access_token}}

{
    "payment_method" : {
        "code": "{{payment_method_code}}",
        "title": "{{payment_method_code}} title",
        "active": true,
        "backend_integration_url": "http://ooope-payment-method/",
        "stores": ["default"],
        "order_status": "complete",
        "countries": ["ES", "US"],
        "currencies": ["EUR", "USD"],
        "custom_config": [
            { "key": "foo", "value": "bar" }
        ]
    }
}
```

# Webhooks on payment methods

As there is no direct communication with the payment providers, every check to be done in payment flow that requires validation or data from a payment provider should be done through the App Builder application.

To implement synchronous validation from payment providers this module uses configurable webhooks.

## Add a webhook

TODO: refer to UI or future REST API.

## Pass data through setPaymentMethod mutation


# GraphQL API

# Rest API

# Requirements


# Changes

- Add new fields in graphql schema to configure the service
- Add new fields in graphql schema to handle data from payment providers
