<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model\Helper;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\OutOfProcessPaymentMethods\Api\PaymentMethodAdapterInterface;
use Magento\OutOfProcessPaymentMethods\Api\PaymentMethodAdapterInterfaceFactory;
use Magento\OutOfProcessPaymentMethods\Api\OutOfProcessPaymentMethodRepositoryInterface;

class Data
{
    /**
     * Data constructor.
     *
     * @param OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository
     * @param PaymentMethodAdapterInterfaceFactory $paymentMethodAdapterInterfaceFactory
     */
    public function __construct(
        private readonly OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository,
        private readonly PaymentMethodAdapterInterfaceFactory         $paymentMethodAdapterInterfaceFactory,
    ) {
    }

    /**
     * Supplies instances of configurable payment method.
     *
     * @param string $code
     * @return PaymentMethodAdapterInterface
     * @throws NoSuchEntityException
     */
    public function getInstance(string $code): PaymentMethodAdapterInterface
    {
        $paymentMethod = $this->paymentMethodRepository->getByCode($code);
        return $this->paymentMethodAdapterInterfaceFactory->create([
            'outOfProcessPaymentMethod' => $paymentMethod
        ]);
    }

    /**
     * Checks if the given payment method code is out of process
     *
     * @param string $code payment method
     * @return bool true when configurable, false otherwise
     */
    public function isOutOfProcess(string $code): bool
    {
        try {
            $this->paymentMethodRepository->getByCode($code);
            return true;
        } catch (NoSuchEntityException) {
            return false;
        }
    }
}
