<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\LiveSearch\Plugin;

use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\LiveSearch\Model\MerchantRegistryClient;

/**
 * Plugin to register merchant for live search on config save
 * Triggered when config is saved using Magento\Framework\App\Config\Storage\WriterInterface
 * which is used by ServicesId module
 */
class RegisterMerchantOnConfigValueSave
{
    /**
     * Config path for environment id
     */
    private const ENVIRONMENT_ID_CONFIG_PATH = 'services_connector/services_id/environment_id';

    /**
     * @var MerchantRegistryClient
     */
    private MerchantRegistryClient $merchantRegistryClient;

    /**
     * @param MerchantRegistryClient $merchantRegistryClient
     */
    public function __construct(
        MerchantRegistryClient $merchantRegistryClient
    ) {
        $this->merchantRegistryClient = $merchantRegistryClient;
    }

    /**
     * Register merchant if environment id has changed.
     *
     * @param WriterInterface $subject
     * @param WriterInterface|null $result
     * @param string $path
     * @param string|null $value
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterSave(WriterInterface $subject, ?WriterInterface $result, string $path, ?string $value) : void
    {
        if ($path === self::ENVIRONMENT_ID_CONFIG_PATH) {
            $environmentId = $value;
            if (!empty($environmentId)) {
                $this->merchantRegistryClient->register($environmentId);
            }
        }
    }
}
