<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearch\Api;

use GuzzleHttp\Exception\GuzzleException;

interface ServiceClientInterface
{
    /**
     * Execute call to SaaS service
     *
     * @param array $headers
     * @param string $path
     * @param string $data
     * @return array
     * @throws KeyInvalidException
     * @throws GuzzleException
     * @throws ApiException
     */
    public function request(array $headers, string $path, string $data = ''): array;

    /**
     * @return bool
     */
    public function isApiKeyValid(): bool;
}
