<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler;


use Magento\LiveSearchAdapter\Model\AttributeMetadata;

class AttributeFilterHandler implements FilterHandlerInterface
{
    /**
     * @var string
     */
    private $filterKey;

    /**
     * @var array
     */
    private $filterValues;

    /**
     * @var AttributeMetadata
     */
    private $attributeMetadata;

    /**
     * @param string $filterKey
     * @param array $filterValues
     * @param AttributeMetadata $attributeMetadata
     */
    public function __construct(
        string $filterKey,
        array $filterValues,
        AttributeMetadata $attributeMetadata
    ) {
        $this->filterKey = $filterKey;
        $this->filterValues = $filterValues;
        $this->attributeMetadata = $attributeMetadata;
    }

    /**
     * @inheritdoc
     */
    public function getFilterKey(): string
    {
        return $this->filterKey;
    }

    /**
     * Get filter values
     * @return array
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getFilterValues(): array
    {
        $optionIds = array_unique($this->filterValues);
        $optionTexts = [];
        foreach ($optionIds as $optionId) {
            $optionText = $this->attributeMetadata->getOptionById($this->filterKey, (int)$optionId);
            if (!empty($optionText)) {
                $optionTexts[] = $optionText;
            }
        }

        return $optionTexts;
    }

    /**
     * @inheritdoc
     */
    public function getFilterType(): string
    {
        return 'in';
    }
}
