<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler;


class RangeFilterHandler implements FilterHandlerInterface
{
    /**
     * @var string
     */
    private $filterKey;

    /**
     * @var array
     */
    private $filterValue;

    /**
     * RangeFilterHandler constructor.
     * @param string $filterKey
     * @param array $filterValue
     */
    public function __construct(
        string $filterKey,
        array $filterValue
    ) {
        $this->filterKey = $filterKey;
        $this->filterValue = $filterValue;
    }
    /**
     * @return string
     */
    public function getFilterKey(): string
    {
        return $this->filterKey;
    }

    /**
     * @return array
     */
    public function getFilterValue(): array
    {
        $range = [];
        if (isset($this->filterValue['from'])) {
            $range['from'] = $this->filterValue['from'];
        }
        if (isset($this->filterValue['to'])) {
            $range['to'] = $this->filterValue['to'];
        }

        return $range;
    }

    /**
     * @return string
     */
    public function getFilterType(): string
    {
        return 'range';
    }
}
