<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler;


use Magento\LiveSearchAdapter\Model\AttributeMetadata;

class AttributeFilterHandler implements FilterHandlerInterface
{
    /**
     * @var string
     */
    private $filterKey;

    /**
     * @var array
     */
    private $filterValue;

    /**
     * @var AttributeMetadata
     */
    private $attributeMetadata;

    /**
     * AttributeFilterHandler constructor.
     * @param string $filterKey
     * @param array $filterValue
     * @param AttributeMetadata $attributeMetadata
     */
    public function __construct(
        string $filterKey,
        array $filterValue,
        AttributeMetadata $attributeMetadata
    ) {
        $this->filterKey = $filterKey;
        $this->filterValue = $filterValue;
        $this->attributeMetadata = $attributeMetadata;
    }
    /**
     * @return string
     */
    public function getFilterKey(): string
    {
        return $this->filterKey;
    }

    /**
     * @return array
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getFilterValue(): array
    {
        $optionIds = array_unique($this->filterValue);
        $optionTexts = [];
        foreach ($optionIds as $optionId) {
            $optionText = $this->attributeMetadata->getOptionById($this->filterKey, (int)$optionId);
            if (!empty($optionText)) {
                $optionTexts[] = $optionText;
            }
        }

        return $optionTexts;
    }

    /**
     * @return string
     */
    public function getFilterType(): string
    {
        return 'in';
    }
}
