<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\Aggregation;

use Magento\Framework\Search\Response\Aggregation\ValueFactory;
use Magento\Framework\Search\Response\Bucket;
use Magento\Framework\Search\Response\BucketFactory;

class AttributeEmptyBucketHandler implements BucketHandlerInterface
{
    /**
     * @var string
     */
    private $attributeCode;

    /**
     * @var BucketFactory
     */
    private $bucketFactory;

    /**
     * @var ValueFactory
     */
    private $valueFactory;

    /**
     * AttributeEmptyBucketHandler constructor.
     * @param string $attributeCode
     * @param BucketFactory $bucketFactory
     * @param ValueFactory $valueFactory
     */
    public function __construct(
        string $attributeCode,
        BucketFactory $bucketFactory,
        ValueFactory $valueFactory
    ) {
        $this->attributeCode = $attributeCode;
        $this->bucketFactory = $bucketFactory;
        $this->valueFactory = $valueFactory;
    }

    /**
     * @return string
     */
    public function getBucketName(): string
    {
        return $this->attributeCode . '_bucket';
    }

    /**
     * @return Bucket|null
     */
    public function getBucket(): ?Bucket
    {
        $bucketValues = [];
        $metrics = [
            'count' => 0,
            'value' => 0
        ];
        $bucketValues[] = $this->valueFactory->create([
            'value' => 0,
            'metrics' => $metrics
        ]);

        return $this->bucketFactory->create([
            'name' => $this->getBucketName(),
            'values' => $bucketValues
        ]);
    }
}
