<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model;

use Magento\Framework\Api\Search\SearchCriteriaInterface;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Search\Api\SearchInterface;

/**
 * Class SearchAdapter
 *
 * Overloads control under search requests
 */
class SearchAdapter implements SearchInterface
{
    /**
     * @var QueryBuilder
     */
    private $queryBuilder;

    /**
     * @var SearchClient
     */
    private $searchClient;

    /**
     * @var SearchResultBuilder
     */
    private $searchResultBuilder;

    /**
     * SearchAdapter constructor.
     * @param QueryBuilder $queryBuilder
     * @param SearchClient $searchClient
     * @param SearchResultBuilder $searchResultBuilder
     */
    public function __construct(
        QueryBuilder $queryBuilder,
        SearchClient $searchClient,
        SearchResultBuilder $searchResultBuilder
    ) {
        $this->queryBuilder = $queryBuilder;
        $this->searchClient = $searchClient;
        $this->searchResultBuilder = $searchResultBuilder;
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultInterface
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\LiveSearch\Api\ApiException
     * @throws \Magento\LiveSearch\Api\KeyInvalidException
     * @throws \Magento\ServicesConnector\Api\KeyNotFoundException
     */
    public function search(SearchCriteriaInterface $searchCriteria): SearchResultInterface
    {
        $body = $this->queryBuilder->build($searchCriteria);

        $saasResult = $this->searchClient->request($body);
        $searchResult = $this->searchResultBuilder->build($saasResult);
        $searchResult->setSearchCriteria($searchCriteria);

        return $searchResult;
    }
}
