<?php

/**
 * Copyright © Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor;

use Exception;

/**
 * Class QueryArgumentProcessorResolver
 */
class QueryArgumentProcessorResolver
{
    /**
     * @var array
     */
    private $queryArgumentProcessors = [];

    /**
     * QueryArgumentProcessorResolver constructor.
     * @param array $queryArgumentProcessors
     */
    public function __construct(
        array $queryArgumentProcessors = []
    ) {
        $this->queryArgumentProcessors = $queryArgumentProcessors;
    }

    /**
     * @param string $queryArgumentName
     * @return QueryArgumentProcessorInterface
     * @throws Exception
     */
    public function resolve(string $queryArgumentName): QueryArgumentProcessorInterface
    {
        if (!isset($this->queryArgumentProcessors[$queryArgumentName])) {
            throw new Exception(sprintf('Failed to find processor for query argument  "%s"', $queryArgumentName));
        }
        return $this->queryArgumentProcessors[$queryArgumentName];
    }
}
