<?php

/**
 * Copyright © Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor;

use GraphQL\QueryBuilder\QueryBuilder;
use Magento\Framework\Api\SearchCriteriaInterface;

interface QueryArgumentProcessorInterface
{
    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getQueryArgumentValue(SearchCriteriaInterface $searchCriteria);

    /**
     * @param QueryBuilder $builder
     */
    public function setQueryArguments(QueryBuilder $builder): void;

    /**
     * @return bool
     */
    public function isRequired(): bool;
}
