<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler;


use Magento\Catalog\Model\Product\Visibility;

class VisibilityFilterHandler implements FilterHandlerInterface
{
    /**
     * @var string
     */
    private $filterKey;

    /**
     * @var array
     */
    private $filterValue;

    /**
     * VisibilityFilterHandler constructor.
     * @param string $filterKey
     * @param array $filterValue
     */
    public function __construct(
        string $filterKey,
        array $filterValue
    ) {
        $this->filterKey = $filterKey;
        $this->filterValue = $filterValue;
    }
    /**
     * @return string
     */
    public function getFilterKey(): string
    {
        return $this->filterKey;
    }

    /**
     * @return array
     */
    public function getFilterValue(): array
    {
        $visibilityIds = array_unique($this->filterValue);
        $visibilityText = [];
        foreach ($visibilityIds as $visibilityId) {
            $visibilityText[] = Visibility::getOptionText((int)$visibilityId)->getText();
        }

        return $visibilityText;
    }

    /**
     * @return string
     */
    public function getFilterType(): string
    {
        return 'in';
    }
}
