<?php
/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\InventorySalesApi\Api\Data;

/**
 * Represents the sales event that brings to appending reservations.
 *
 * @api
 */
interface SalesEventInterface extends \Magento\Framework\Api\ExtensibleDataInterface
{
    /**#@+
     * Constants for event types
     */
    public const EVENT_ORDER_PLACED = 'order_placed';
    public const EVENT_ORDER_CANCELED = 'order_canceled';
    public const EVENT_ORDER_PLACE_FAILED = 'order_place_failed';
    public const EVENT_SHIPMENT_CREATED = 'shipment_created';
    public const EVENT_CREDITMEMO_CREATED = 'creditmemo_created';
    public const EVENT_INVOICE_CREATED = 'invoice_created';
    /**#@-*/

    /**#@+
     * Constants for event object types
     */
    public const OBJECT_TYPE_ORDER = 'order';
    /**#@-*/

    /**
     * Get type
     *
     * @return string
     */
    public function getType(): string;

    /**
     * Get object type
     *
     * @return string
     */
    public function getObjectType(): string;

    /**
     * Get object id
     *
     * @return string
     */
    public function getObjectId(): string;

    /**
     * Retrieve existing extension attributes object
     *
     * @return \Magento\InventorySalesApi\Api\Data\SalesEventExtensionInterface|null
     */
    public function getExtensionAttributes(): ?\Magento\InventorySalesApi\Api\Data\SalesEventExtensionInterface;

    /**
     * Set an extension attributes object
     *
     * @param \Magento\InventorySalesApi\Api\Data\SalesEventExtensionInterface $extensionAttributes
     * @return void
     */
    public function setExtensionAttributes(
        \Magento\InventorySalesApi\Api\Data\SalesEventExtensionInterface $extensionAttributes
    ): void;
}
