/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
define([
    'Magento_Ui/js/grid/columns/column',
    'underscore'
], function (Column, _) {
    'use strict'; //eslint-disable-line

    return Column.extend({
        defaults: {
            bodyTmpl: 'Magento_InventorySalesAdminUi/stock/grid/cell/sales-channel-cell.html'
        },

        /**
         * Get sales channels grouped by type
         *
         * @param {Object} record - Record object
         * @returns {Array} Result array
         */
        getSalesChannelsGroupedByType: function (record) {
            var result = [];

            _.each(record[this.index], function (channels, type) {
                result.push({
                    type: type,
                    channels: channels
                });
            });

            return result;
        }
    });
});
