/**
 * Copyright 2019 Adobe
 * All Rights Reserved.
 */
define([
    'Magento_Ui/js/form/components/fieldset',
    'ko'
], function (Fieldset, ko) {
    'use strict'; //eslint-disable-line

    /**
     * TODO Remove when issue is resolved in core.
     * @see Please check issue in core for more details: https://github.com/magento/magento2/issues/22067.
     */
    return Fieldset.extend(ko).extend(
        {
            /**
             * Convert `visible` value from string ('1', '0') to bool (true, false)
             */
            initialize: function () {
                this._super();

                // eslint-disable-next-line vars-on-top
                var visible = this.visible;

                this.visible = ko.computed({
                    /**
                     * @returns {Boolean}
                     */
                    read: function () {
                        return visible();
                    },

                    /**
                     * @param {String} value
                     */
                    write: function (value) {
                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));
                        visible(value);
                    },
                    owner: this
                });
                this.visible(visible());
            }
        }
    );
});
