# Magento_GoogleOptimizer module

This module implements functionality of Google Experiment tool that is the part of Google Analytics functionality.

## Installation

Before installing this module, note that the Magento_GoogleOptimizer is dependent on the following modules:

- `Magento_GoogleAnalytics`
- `Magento_Catalog`
- `Magento_Cms`
- `Magento_Ui`

For information about a module installation in Magento 2, see [Enable or disable modules](https://experienceleague.adobe.com/docs/commerce-operations/installation-guide/tutorials/manage-modules.html).

## Extensibility

Extension developers can interact with the Magento_GoogleOptimizer module. For more information about the Magento extension mechanism, see [Magento plugins](https://developer.adobe.com/commerce/php/development/components/plugins/).

[The Magento dependency injection mechanism](https://developer.adobe.com/commerce/php/development/components/dependency-injection/) enables you to override the functionality of the Magento_GoogleOptimizer module.

### Layouts

This module introduces the following layouts in the `view/frontend/layout` and `view/adminhtml/layout` directories:

- `view/adminhtml/layout`:
    - `catalog_product_new`
    - `cms_page_edit`
- `view/frontend/layout`:
    - `catalog_category_view`
    - `catalog_product_view`
    - `cms_page_view`

For more information about a layout in Magento 2, see the [Layout documentation](https://developer.adobe.com/commerce/frontend-core/guide/layouts/).

### UI components

This module extends following ui components located in the `view/adminhtml/ui_component` directory:

- `category_form`
- `cms_page_form`
- `new_category_form`

For information about a UI component in Magento 2, see [Overview of UI components](https://developer.adobe.com/commerce/frontend-core/ui-components/).

## Additional information

Google Experiment (on Google side) allows to make two variants of the same page and compare their popularity.
From Magento side, code generated by Google should be saved and displayed on a particular page.
Google Experiment functionality is available on pages of products, categories and cms pages.
This allows to save different codes for products and categories on different store views.

This functionality can be switched on and off on the configuration page (`Stores -> Configuration -> General -> Google Api -> Google Analytics`).
Also this functionality depends on Google Analytics module and configuration options.

[Learn how to configure Google Content Experiments](https://experienceleague.adobe.com/docs/commerce-admin/marketing/google-tools/google-content-experiments.html).
