<?php
/**
 * Copyright © Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\ExternalSchemaGraphQlServer\Model;

use Magento\Framework\ObjectManagerInterface;

/**
 * HTTP client factory
 */
class HttpClientFactory
{
    private ObjectManagerInterface $objectManager;

    /**
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(
        ObjectManagerInterface $objectManager
    ) {
        $this->objectManager = $objectManager;
    }

    /**
     * Create HTTP client
     *
     * @param array $settings
     * @return HttpClient
     */
    public function create(array $settings = []): HttpClient
    {
        return $this->objectManager->create(HttpClient::class, $settings);
    }
}
