<?php
/**
 * Copyright © Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\ExternalSchemaGraphQlServer\Model\Config;

use Magento\ExternalSchemaGraphQlServer\Model\HttpClientFactory;
use Magento\Framework\Config\FileResolverInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * External schema file resolver
 */
class FileResolver implements FileResolverInterface
{
    private FileResolverInterface $fileResolver;
    private HttpClientFactory $clientFactory;
    private ScopeConfigInterface $config;

    private static string $path = 'graphql/schema/url';

    /**
     * @param FileResolverInterface $fileResolver
     * @param HttpClientFactory $clientFactory
     * @param ScopeConfigInterface $config
     */
    public function __construct(
        FileResolverInterface $fileResolver,
        HttpClientFactory $clientFactory,
        ScopeConfigInterface $config
    ) {
        $this->fileResolver = $fileResolver;
        $this->clientFactory = $clientFactory;
        $this->config = $config;
    }

    /**
     * Return content including remote schema
     *
     * @param $filename
     * @param $scope
     * @return array
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function get($filename, $scope): array
    {
        $content = $this->fileResolver->get($filename, $scope);
        if ($content instanceof \Iterator) {
            $content = iterator_to_array($content);
        }

        $remoteSchemaPath = $this->config->getValue(self::$path);
        if ($remoteSchemaPath != null) {
            $client = $this->clientFactory->create();
            $remote = $client->get(
                $remoteSchemaPath,
                ['headers' => ['Content-Type' => 'text/plain']]
            );
            $content[] = $remote->getBody()->getContents();
        }
        return $content;
    }
}
