<?php
/**
 * Copyright © Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\ExternalSchemaGraphQlServer\Resolver;

use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\Value;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\ExternalSchemaGraphQlServer\Model\HttpClientFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Serialize\Serializer\Json as JsonSerializer;

/**
 * External schema proxy post resolver
 */
class ProxyPostResolver implements ResolverInterface
{
    private static $path = 'graphql/remote/host';

    private HttpClientFactory $clientFactory;
    private ScopeConfigInterface $config;
    private JsonSerializer $serializer;

    /**
     * @param HttpClientFactory $clientFactory
     * @param ScopeConfigInterface $config
     * @param JsonSerializer $serializer
     */
    public function __construct(
        HttpClientFactory $clientFactory,
        ScopeConfigInterface $config,
        JsonSerializer $serializer
    ) {
        $this->clientFactory = $clientFactory;
        $this->config = $config;
        $this->serializer = $serializer;
    }

    /**
     * @param Field $field
     * @param $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|bool|float|int|Value|mixed|string|null
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $client = $this->clientFactory->create();
        $result = $client->post(
            $this->config->getValue(self::$path) . $field->getName(),
            [
                'headers' => ['Content-Type' => 'application/json'],
                'body' => $this->serializer->serialize($args)
            ]
        );
        return $this->serializer->unserialize($result->getBody()->getContents());
    }
}
