<?php
/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Elasticsearch\Model\Adapter\FieldMapper\Product\AttributeAdapter;

use Magento\Framework\Api\CustomAttributesDataInterface;

/**
 * Dummy class for Not EAV attribute.
 * @SuppressWarnings(PHPMD)
 * @deprecated Elasticsearch is no longer supported by Adobe
 * @see this class will be responsible for ES only
 */
class DummyAttribute implements CustomAttributesDataInterface
{
    /**
     * Get an attribute value.
     *
     * @param string $attributeCode
     * @return \Magento\Framework\Api\AttributeInterface|null
     */
    public function getCustomAttribute($attributeCode)
    {
        return null;
    }

    /**
     * Set an attribute value for a given attribute code
     *
     * @param string $attributeCode
     * @param mixed $attributeValue
     * @return $this
     */
    public function setCustomAttribute($attributeCode, $attributeValue)
    {
        return $this;
    }

    /**
     * Retrieve custom attributes values.
     *
     * @return \Magento\Framework\Api\AttributeInterface[]|null
     */
    public function getCustomAttributes()
    {
        return null;
    }

    /**
     * Set array of custom attributes
     *
     * @param \Magento\Framework\Api\AttributeInterface[] $attributes
     * @return $this
     * @throws \LogicException
     */
    public function setCustomAttributes(array $attributes)
    {
        return $this;
    }

    /**
     * Get property value that guarantee of using an attribute in sort purposes on the storefront.
     *
     * @return bool
     */
    public function getUsedForSortBy()
    {
        return false;
    }

    /**
     * Dummy attribute doesn't have backend type.
     *
     * @return null
     */
    public function getBackendType()
    {
        return null;
    }
}
