<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\Elasticsearch\Test\Unit\Plugin\Model\ResourceModel\Attribute;

use Magento\Catalog\Api\Data\EavAttributeInterface;
use Magento\Elasticsearch\Model\Adapter\FieldType;
use Magento\Elasticsearch\Model\Adapter\Index\IndexNameResolver;
use Magento\Elasticsearch\Model\Client\Elasticsearch;
use Magento\Elasticsearch\Model\Config;
use Magento\Elasticsearch\SearchAdapter\ConnectionManager;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager as ObjectManagerHelper;
use Magento\Store\Model\StoreManagerInterface;
use PHPUnit_Framework_MockObject_MockObject as MockObject;

/**
 * Tests \Magento\Elasticsearch\Plugin\Model\ResourceModel\Attribute\Save.
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class UpdateMappingTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \Magento\Elasticsearch\Plugin\Model\ResourceModel\Attribute\UpdateMapping
     */
    private $plugin;

    /**
     * @var IndexNameResolver|MockObject
     */
    private $indexNameResolverMock;

    /**
     * @var ConnectionManager|MockObject
     */
    private $connectionManagerMock;

    /**
     * @var Config|MockObject
     */
    private $clientConfigMock;

    /**
     * @var StoreManagerInterface|MockObject
     */
    private $storeManagerMock;

    /**
     * @var FieldType|MockObject
     */
    private $fieldTypeMock;

    /**
     * @var ObjectManagerHelper
     */
    private $objectManager;

    /**
     * @inheritdoc
     */
    protected function setUp()
    {
        $this->indexNameResolverMock = $this->getMockBuilder(IndexNameResolver::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->connectionManagerMock = $this->getMockBuilder(ConnectionManager::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->clientConfigMock = $this->getMockBuilder(Config::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->storeManagerMock = $this->getMockBuilder(StoreManagerInterface::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->fieldTypeMock = $this->getMockBuilder(FieldType::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->objectManager = new ObjectManagerHelper($this);
        $this->plugin = $this->objectManager->getObject(
            \Magento\Elasticsearch\Plugin\Model\ResourceModel\Attribute\UpdateMapping::class,
            [
                'indexNameResolver' => $this->indexNameResolverMock,
                'connectionManager' => $this->connectionManagerMock,
                'storeManager' => $this->storeManagerMock,
                'fieldType' => $this->fieldTypeMock,
                'clientConfig' => $this->clientConfigMock,
            ]
        );
    }

    /**
     * @return void
     */
    public function testAroundSave()
    {
        /** @var \Magento\Catalog\Model\ResourceModel\Attribute|MockObject $subject */
        $subject = $this->getMockBuilder(\Magento\Catalog\Model\ResourceModel\Attribute::class)
            ->disableOriginalConstructor()
            ->getMock();
        /** @var \Magento\Eav\Model\Entity\Attribute\AbstractAttribute|MockObject $attribute */
        $attribute = $this->getMockBuilder(\Magento\Eav\Model\Entity\Attribute\AbstractAttribute::class)
            ->setMethods(['getAttributeCode', 'getData'])
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $closure = function () use ($subject) {
            return $subject;
        };
        $storeMock = $this->getMockBuilder(\Magento\Store\Model\Store::class)
            ->disableOriginalConstructor()
            ->getMock();
        $clientMock = $this->getMockBuilder(Elasticsearch::class)
            ->disableOriginalConstructor()
            ->getMock();

        $storeId = 1;
        $mappedIndexerId = 'product';
        $attributes = [
            'test' => [
                'type' => 'string',
            ],
        ];

        $indexName = 'magento2_product_1_v2';
        $searchEntityType = 'document';

        $this->clientConfigMock
            ->expects($this->once())
            ->method('isElasticsearchEnabled')
            ->willReturn(true);
        $this->indexNameResolverMock
            ->expects($this->once())
            ->method('getIndexMapping')
            ->with(\Magento\CatalogSearch\Model\Indexer\Fulltext::INDEXER_ID)
            ->willReturn($mappedIndexerId);
        $this->fieldTypeMock->expects($this->once())
            ->method('getFieldType')
            ->with($attribute)
            ->willReturn('string');
        $this->connectionManagerMock
            ->expects($this->once())
            ->method('getConnection')
            ->willReturn($clientMock);
        $this->storeManagerMock
            ->expects($this->once())
            ->method('getStores')
            ->willReturn([$storeId => $storeMock]);
        $this->indexNameResolverMock
            ->expects($this->once())
            ->method('getIndexName')
            ->with($storeId, $mappedIndexerId, [])
            ->willReturn($indexName);
        $this->clientConfigMock
            ->expects($this->once())
            ->method('getEntityType')
            ->willReturn($searchEntityType);
        $clientMock->expects($this->once())
            ->method('addFieldsMapping')
            ->with($attributes, $indexName, $searchEntityType);
        $attribute->expects($this->once())->method('getAttributeCode')
            ->willReturn('test');
        $attribute->expects($this->atLeastOnce())->method('getData')
            ->willReturnMap(
                [
                    [EavAttributeInterface::IS_SEARCHABLE, null, 1],
                ]
            );

        $this->plugin->aroundSave($subject, $closure, $attribute);
    }
}
