<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\DataServicesHipaa\Block;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

/**
 * Block for setting commerce events HIPAA configs
 */
class CommerceEvents extends Template
{
    /**
     * Path to Data Services Commerce Events Enabled config
     */
    public const XML_PATH_DATA_SERVICES_COMMERCE_EVENTS_ENABLED = 'general/data_services/commerce_events_enabled';

    /**
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     * @param SerializerInterface $serializer
     */
    public function __construct(
        private Context                       $context,
        private readonly ScopeConfigInterface $scopeConfig,
        private readonly SerializerInterface  $serializer,
    ) {
        parent::__construct($context);
    }

    /**
     * Returns Commerce Events enablement status.
     *
     * Returns false if Commerce Events are disabled
     *
     * @return string
     */
    public function getCommerceEventsEnabled(): string
    {
        return $this->serializer->serialize(
            (bool) $this->scopeConfig->getValue(self::XML_PATH_DATA_SERVICES_COMMERCE_EVENTS_ENABLED)
        );
    }
}
