<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\DataServicesGraphQl\Model\Resolver;

use Magento\Framework\App\CacheInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Framework\Module\PackageInfoFactory;


/**
 * Class that implements the dataServicesMagentoExtensionContext resolver
 */
class MagentoExtensionContext implements ResolverInterface
{
    private const MODULE_NAME = 'Magento_DataServices';

    /** @var PackageInfoFactory */
    private $packageInfoFactory;

    /**
     * @var CacheInterface
     */
    private $cache;

    /**
     * StorefrontInstanceContext constructor.
     * @param PackageInfoFactory $packageInfoFactory
     * @param CacheInterface $cache
     */
    public function __construct(PackageInfoFactory $packageInfoFactory, CacheInterface $cache)
    {
        $this->packageInfoFactory = $packageInfoFactory;
        $this->cache = $cache;
    }


    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        return [
            'magento_extension_version' => $this->getDataServicesVersion()
        ];
    }

    /**
     * Get data services package version
     *
     * @return string|null
     */
    public function getDataServicesVersion(): ?string

    {
        $version = $this->cache->load(self::MODULE_NAME);
        if (!$version) {
            $packageInfo = $this->packageInfoFactory->create();
            $version = $packageInfo->getVersion(self::MODULE_NAME);
            $this->cache->save($version, self::MODULE_NAME);
        }

        return $version ?? null;

    }
}
