<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Sales\Block\Adminhtml\Order\Create;

use Magento\CustomAttributeSerializable\Block\Adminhtml\Order\Create\CustomAttributesForm;
use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Block\Adminhtml\Order\Create\Data;

/**
 * Plugin to append custom attributes form after the 'gift_options' section.
 */
class DataPlugin
{
    /**
     * Appends the custom attributes form HTML after the 'gift_options' section.
     *
     * @param Data $subject
     * @param string $html
     * @param string $alias
     * @param bool $useCache
     * @return string
     * @throws LocalizedException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetChildHtml(Data $subject, string $html, $alias = '', $useCache = true): string
    {
        if ($alias !== 'gift_options') {
            return $html;
        }
        $layout = $subject->getLayout();
        $block = $layout->createBlock(CustomAttributesForm::class);

        return $html . $block->toHtml();
    }
}
