<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\ResourceModel;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\Framework\ObjectManager\ResetAfterRequestInterface;
use Magento\Tax\Model\ResourceModel\TaxClass as ResourceTaxClass;

/**
 * Overrides the TaxClass resource model class to add custom attributes as serializable fields
 */
class TaxClass extends ResourceTaxClass implements ResetAfterRequestInterface
{
    /**
     * @var array
     */
    protected $_serializableFields = [AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE => [[], []]];

    /**
     * @inheritDoc
     */
    public function _resetState(): void
    {
        $this->_uniqueFields = null;
        $this->serializer = null;
    }
}
