<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\ResourceModel\Order\Invoice;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\Sales\Model\ResourceModel\Order\Invoice\Item as ResourceOrderInvoiceItem;

/**
 * Overrides the Order Invoice Item resource model class to add custom attributes as serializable fields
 */
class Item extends ResourceOrderInvoiceItem
{
    /**
     * Model initialization
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_serializableFields = array_merge(
            $this->_serializableFields,
            [AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE => [[], []]]
        );
    }
}
