<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\ResourceModel;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\Sales\Model\ResourceModel\Order as ResourceOrder;

/**
 * Overrides the Order resource model class to add custom attributes as serializable fields
 */
class Order extends ResourceOrder
{
    /**
     * @var array
     */
    protected $_serializableFields = [AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE => [[], []]];
}
