<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\Quote;

use Magento\CustomAttributeSerializable\Model\SerializableAttributesTrait;
use Magento\Framework\ObjectManager\ResetAfterRequestInterface;

/**
 * Overrides the Quote Item class to add manage custom attributes from the serialized field
 */
class Item extends \Magento\Quote\Model\Quote\Item  implements ResetAfterRequestInterface
{
    use SerializableAttributesTrait;

    /**
     * @inheritDoc
     */
    public function _resetState(): void
    {
        $this->_origData = null;
        $this->customAttributesChanged = false;
        $this->_quote = null;
    }
}
