<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Test\Unit\Model\CustomAttributes;

use Magento\CustomAttributeSerializable\Model\CustomAttributes\CustomAttributeConverter;
use Magento\Framework\Api\AttributeInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * Test for @see CustomAttributeConverter
 */
class CustomAttributeConverterTest extends TestCase
{
    public function testToSerializableFormat()
    {
        $customAttributes = [
            $this->createCustomAttribute('attribute_code_1', 'value_1'),
            $this->createCustomAttribute('attribute_code_2', ''),
            $this->createCustomAttribute('attribute_code_3', '0'),
            $this->createCustomAttribute('attribute_code_4', 0),
            $this->createCustomAttribute('attribute_code_5', null),
            $this->createCustomAttribute('attribute_code_6', '00'),
            $this->createCustomAttribute('attribute_code_7', 'null'),
        ];

        $expected = [
            'attribute_code_1' => 'value_1',
            'attribute_code_3' => '0',
            'attribute_code_4' => 0,
            'attribute_code_6' => '00',
            'attribute_code_7' => 'null',
        ];

        $this->assertEquals($expected, (new CustomAttributeConverter())->toSerializableFormat($customAttributes));
    }

    /**
     * Creates a Mock of AttributeInterface
     *
     * @param string $code
     * @param $value
     * @return MockObject
     * @throws \PHPUnit\Framework\MockObject\Exception
     */
    private function createCustomAttribute(string $code, $value): MockObject
    {
        $customAttribute = $this->createMock(AttributeInterface::class);
        $customAttribute->expects(self::any())
            ->method('getAttributeCode')
            ->willReturn($code);
        $customAttribute->expects(self::any())
            ->method('getValue')
            ->willReturn($value);

        return $customAttribute;
    }
}
