<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Sales\Controller\Adminhtml\Order\Create;

use Magento\Backend\Model\Session\Quote as SessionQuote;
use Magento\CustomAttributeSerializable\Model\CustomAttributes\RequestCustomAttributeConverter;
use Magento\Sales\Controller\Adminhtml\Order\Create\Save as OrderSave;
use Magento\Framework\App\RequestInterface;

/**
 * Plugin to save custom attributes on the quote before placing an order.
 */
class OrderCreateSavePlugin
{
    /**
     * @param SessionQuote $sessionQuote
     * @param RequestInterface $request
     * @param RequestCustomAttributeConverter $attributeConverter
     */
    public function __construct(
        private readonly SessionQuote $sessionQuote,
        private readonly RequestInterface $request,
        private readonly RequestCustomAttributeConverter $attributeConverter,
    ) {
    }

    /**
     * Before placing order, read custom attributes from the request and store them on the quote
     *
     * @param OrderSave $subject
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecute(OrderSave $subject): void
    {
        $attributes = $this->request->getParam('custom_order_attributes', []);

        if (empty($attributes)) {
            return;
        }

        $quote = $this->sessionQuote->getQuote();
        $quote->setCustomAttributes(is_array($attributes) ? $this->attributeConverter->convert($attributes) : []);
        $quote->setDataChanges(true);
    }
}
