<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\CustomAttributeSerializable\Model\ExtendedCustomAttributesProcessor;
use Magento\Framework\Api\CustomAttributesDataInterface;
use Magento\Framework\Reflection\DataObjectProcessor;

/**
 * Add custom attributes to the output data array
 */
class DataObjectProcessorAfterBuild
{
    /**
     * @param ExtendedCustomAttributesProcessor $extendedCustomAttributesProcessor
     * @param AttributesConfigurationPool $attributesConfigurationPool
     */
    public function __construct(
        private readonly ExtendedCustomAttributesProcessor $extendedCustomAttributesProcessor,
        private readonly AttributesConfigurationPool $attributesConfigurationPool
    ) {
    }

    /**
     * Add custom attributes to the output data array for the specified data object type
     *
     * @param DataObjectProcessor $subject
     * @param array $result
     * @param object $dataObject
     * @param string $dataObjectType
     * @return array
     */
    public function afterBuildOutputDataArray(DataObjectProcessor $subject, $result, $dataObject, $dataObjectType)
    {
        if (in_array(trim($dataObjectType, '\\'), $this->attributesConfigurationPool->getApiInterfaces())) {
            $value = array_merge(
                $result[CustomAttributesDataInterface::CUSTOM_ATTRIBUTES] ?? [],
                $this->extendedCustomAttributesProcessor->buildOutputDataArray($dataObject, $dataObjectType)
            );
            if (!empty($value)) {
                $result[CustomAttributesDataInterface::CUSTOM_ATTRIBUTES] = array_filter($value, function ($item) {
                    return !empty($item['value']) || $item['value'] === '0' || $item['value'] === 0;
                });
            }
        }

        return $result;
    }
}
