<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\Extensibility;

/**
 * Appends custom attributes information to the specific path.
 */
class CustomAttributePathAppender
{
    private const CUSTOM_ATTRIBUTES = 'custom_attributes';

    /**
     * Appends custom attributes information to the specific path.
     *
     * For example, if the path is 'order.items[]', the custom attributes information will be
     * added to the first element of 'items' array inside 'order' section.
     *
     * @param array $array
     * @param string|null $path
     * @param string $delimiter
     * @return void
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     */
    public function append(array &$array, ?string $path = null, string $delimiter = '.'): void
    {
        if ($path === null || $path === 'root') {
            $array[self::CUSTOM_ATTRIBUTES] = $this->getCustomAttributeInfo();
            return;
        }

        if (str_ends_with($path, '[]')) {
            $isArray = true;
            $path = substr($path, 0, -2);
        } else {
            $isArray = false;
        }

        $keys = explode($delimiter, $path);
        $tmp = &$array;

        foreach ($keys as $key) {
            if (!isset($tmp[$key]) || !is_array($tmp[$key])) {
                return;
            }
            $tmp = &$tmp[$key];
        }

        if (!$isArray) {
            $tmp[self::CUSTOM_ATTRIBUTES] = $this->getCustomAttributeInfo();
        } elseif (is_array($tmp) && is_array($tmp[array_key_first($tmp)])) {
            $tmp[array_key_first($tmp)][self::CUSTOM_ATTRIBUTES] = $this->getCustomAttributeInfo();
        }
    }

    /**
     * Returns custom attributes information
     *
     * @return array
     */
    private function getCustomAttributeInfo(): array
    {
        return [
            [
                'attribute_code' => 'string',
                'value' => 'mixed',
            ]
        ];
    }
}
