<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\CustomAttributes;

use Magento\Framework\Serialize\Serializer\Json;
use InvalidArgumentException;

/**
 * Converts attributes from request array to custom attributes array.
 */
class RequestCustomAttributeConverter
{
    /**
     * @param Json $json
     */
    public function __construct(
        private readonly Json $json
    ) {
    }

    /**
     * Converts attributes from request array to custom attributes array.
     *
     * @param array $attributes
     * @return array
     */
    public function convert(array $attributes): array
    {
        $customAttributes = [];
        foreach ($attributes as $attribute) {
            if (!isset($attribute['code']) || !isset($attribute['value'])) {
                continue;
            }
            $customAttributes[$attribute['code']] = $this->convertValue($attribute['value']);
        }

        return $customAttributes;
    }

    /**
     * Converts a single attribute value.
     *
     * @param string $value
     * @return mixed
     */
    private function convertValue(string $value): mixed
    {
        $value = trim($value);
        if (!str_starts_with($value, '{') && !str_starts_with($value, '[')) {
            return $value;
        }
        try {
            return $this->json->unserialize($value);
        } catch (InvalidArgumentException $e) {
            return $value;
        }
    }
}
