<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Block\Adminhtml\Order\View\Tab;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Api\AttributeInterface;
use Magento\Framework\Registry;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Custom Attributes tab for the Order View page in the Admin Panel.
 */
class CustomAttributes extends Template implements TabInterface
{
    /**
     * @param Template\Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        private readonly Registry $registry,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * @inheritDoc
     */
    public function getTabLabel(): string
    {
        return __('Custom Attributes')->render();
    }

    /**
     * @inheritDoc
     */
    public function getTabTitle(): string
    {
        return __('Custom Attributes')->render();
    }

    /**
     * @inheritDoc
     */
    public function canShowTab(): bool
    {
        return $this->getOrder() !== null;
    }

    /**
     * @inheritDoc
     */
    public function isHidden(): bool
    {
        return false;
    }

    /**
     * Returns the current order from the registry.
     *
     * @return OrderInterface|null
     */
    public function getOrder(): ?OrderInterface
    {
        return $this->registry->registry('current_order');
    }

    /**
     * Returns a normalized list of key => value pairs for rendering
     */
    public function getOrderCustomAttributes(): array
    {
        $order = $this->getOrder();
        if (!$order) {
            return [];
        }

        $attrs = $order->getCustomAttributes();

        if (!is_array($attrs) || empty($attrs)) {
            return [];
        }

        $result = [];
        foreach ($attrs as $attr) {
            if ($attr instanceof AttributeInterface) {
                $result[$attr->getAttributeCode()] = $attr->getValue();
            }
        }

        ksort($result, SORT_NATURAL | SORT_FLAG_CASE);
        return $result;
    }
}
