<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Webhook;

use Magento\AdobeCommerceWebhooks\Model\Webhook;
use Magento\AdobeCommerceWebhooks\Model\WebhookInfo\WebhookInfo;
use Magento\CustomAttributeSerializable\Model\Extensibility\CustomAttributePathAppender;

/**
 * The plugin class for the webhook info to add custom attributes information
 */
class CustomAttributeInfo
{
    /**
     * Default paths to append custom attributes
     *
     * @var array
     */
    private array $defaultPaths = [
        'root',
        'items[]'
    ];

    /**
     * @param CustomAttributePathAppender $customAttributePathAppender
     * @param array $webhooks
     */
    public function __construct(
        private readonly CustomAttributePathAppender $customAttributePathAppender,
        private readonly array $webhooks = []
    ) {
    }

    /**
     * Appends custom attributes information to the webhook info for the specific webhooks
     *
     * @param WebhookInfo $subject
     * @param array $result
     * @param Webhook $webhook
     * @param int $nestedLevel
     * @return array
     */
    public function afterGetInfo(WebhookInfo $subject, array $result, Webhook $webhook, int $nestedLevel): array
    {
        if (!array_key_exists($webhook->getName(), $this->webhooks)) {
            return $result;
        }

        $paths = is_array($this->webhooks[$webhook->getName()]) ?
            $this->webhooks[$webhook->getName()] : $this->defaultPaths;
        foreach ($paths as $path) {
            $this->customAttributePathAppender->append($result, $path);
        }

        return $result;
    }
}
