<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\AdobeCommerceEventsClient\Event\EventInfo;
use Magento\CustomAttributeSerializable\Model\Extensibility\CustomAttributePathAppender;

/**
 * The plugin class for the event info to add custom attributes information
 */
class CustomAttributeInfo
{
    /**
     * Default paths to append custom attributes
     *
     * @var array
     */
    private array $defaultPaths = [
        'root',
        'items[]'
    ];

    /**
     * @param CustomAttributePathAppender $customAttributePathAppender
     * @param array $events
     */
    public function __construct(
        private readonly CustomAttributePathAppender $customAttributePathAppender,
        private readonly array $events = []
    ) {
    }

    /**
     * Appends custom attributes information to the event info for the specific events
     *
     * @param EventInfo $subject
     * @param array $result
     * @param Event $event
     * @param int $nestedLevel
     * @return array
     */
    public function afterGetInfo(EventInfo $subject, array $result, Event $event, int $nestedLevel): array
    {
        if (!array_key_exists($event->getName(), $this->events)) {
            return $result;
        }

        $paths = is_array($this->events[$event->getName()]) ? $this->events[$event->getName()] : $this->defaultPaths;
        foreach ($paths as $path) {
            $this->customAttributePathAppender->append($result, $path);
        }

        return $result;
    }
}
