<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Observer;

use Magento\CustomAttributeSerializable\Model\CustomAttributes\CustomAttributeConverter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Observer to copy custom attributes from quote to order
 */
class QuoteSubmitBeforeCustomAttributeSerializable implements ObserverInterface
{
    /**
     * @param CustomAttributeConverter $attributeConverter
     */
    public function __construct(
        private readonly CustomAttributeConverter $attributeConverter
    ) {
    }

    /**
     * Copies custom attributes from quote to order.
     *
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        $quote = $observer->getEvent()->getQuote();

        $customAttributes = $quote->getCustomAttributes();
        if (empty($customAttributes)) {
            return;
        }
        $order = $observer->getEvent()->getOrder();
        $order->setCustomAttributes($customAttributes);
        $order->setCustomAttributesSerializable($this->attributeConverter->toSerializableFormat($customAttributes));
    }
}
