<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\Cart\Totals;

use Magento\CustomAttributeSerializable\Model\SerializableAttributesTrait;

/**
 * Overrides the Cart Totals Item model class to add custom attributes from the serialized field
 */
class Item extends \Magento\Quote\Model\Cart\Totals\Item
{
    use SerializableAttributesTrait;

    /**
     * @inheritDoc
     */
    public function getIgnoredAttributes(): array
    {
        return array_merge($this->ignoreAttributes, [
            'quote_id',
            'created_at',
            'updated_at',
            'product_id',
            'store_id',
            'parent_item_id',
            'is_virtual',
            'sku',
            'description',
            'applied_rule_ids',
            'additional_data',
            'is_qty_decimal',
            'no_discount',
            'weight',
            'custom_price',
            'row_weight',
            'product_type',
            'base_tax_before_discount',
            'tax_before_discount',
            'original_custom_price',
            'redirect_url',
            'base_cost',
            'discount_tax_compensation_amount',
            'base_discount_tax_compensation_amount',
            'event_id',
            'giftregistry_item_id',
            'weee_tax_applied_row_amount',
            'weee_tax_disposition',
            'weee_tax_row_disposition',
            'base_weee_tax_applied_amount',
            'base_weee_tax_applied_row_amnt',
            'base_weee_tax_disposition',
            'base_weee_tax_row_disposition',
            'gift_message_id',
            'gw_id',
            'gw_base_price',
            'gw_price',
            'gw_base_tax_amount',
            'gw_tax_amount',
            'free_shipping',
            'extension_attribute_negotiable_quote_item_quote_item_id',
            'extension_attribute_negotiable_quote_item_original_price',
            'extension_attribute_negotiable_quote_item_original_tax_amount',
            'extension_attribute_negotiable_quote_item_original_discount_amount',
            'extension_attribute_negotiable_quote_item_negotiated_price_type',
            'extension_attribute_negotiable_quote_item_negotiated_price_value',
            'extension_attribute_negotiable_quote_item_is_discounting_locked',
            'extension_attribute_negotiable_quote_item_min_qty',
            'extension_attribute_negotiable_quote_item_max_qty',
            'qty_options',
            'product',
            'tax_class_id',
            'has_error',
            'stock_state_result'
        ]);
    }
}
