<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Block\Adminhtml\Order\Create;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Model\Session\Quote as SessionQuote;

/**
 * Block to render custom attributes form in the order create page.
 * This form allows users to set custom attributes for the order.
 */
class CustomAttributesForm extends Template
{
    /**
     * @var string
     */
    protected $_template = 'Magento_CustomAttributeSerializable::order/create/custom_attributes_form.phtml';

    /**
     * @param Context $context
     * @param SessionQuote $sessionQuote
     * @param array $data
     */
    public function __construct(
        Context $context,
        private readonly SessionQuote $sessionQuote,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * Returns the custom attributes of the quote.
     *
     * @return array
     */
    public function getQuoteAttributes(): array
    {
        $quote = $this->sessionQuote->getQuote();
        $result = [];
        foreach ($quote->getCustomAttributes() as $attribute) {
            $result[$attribute->getAttributeCode()] = $attribute->getValue();
        }
        return $result;
    }
}
