<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Observer;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Unserialize custom attributes after model is loaded
 */
class CustomAttributeSerializableAfterLoadObserver implements ObserverInterface
{
    /**
     * @param Json $json
     */
    public function __construct(private readonly Json $json)
    {
    }

    /**
     * Unserialize custom attributes after model is loaded.
     *
     * Does nothing if custom attributes are not serialized or empty or already unserialized.
     *
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer)
    {
        $object = $observer->getEvent()->getDataObject();
        if (empty($object->getData(AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE)) ||
            !is_string($object->getData(AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE))
        ) {
            return $this;
        }

        try {
            $attributes = $this->json->unserialize(
                $object->getData(AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE)
            );
            $object->setData(AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE, $attributes);
            if (is_array($attributes)) {
                $object->setCustomAttributes($attributes);
            }
        } catch (\InvalidArgumentException $e) {
            return $this;
        }

        return $this;
    }
}
