<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model;

/**
 *  Overrides the Order model class to add manage custom attributes from the serialized field
 */
class Order extends \Magento\Sales\Model\Order
{
    use SerializableAttributesTrait;

    /**
     * Returns the list of attributes that should be ignored as custom attributes
     *
     * @return array
     */
    public function getIgnoredAttributes(): array
    {
        return array_merge($this->ignoreAttributes, [
            'base_customer_balance_amount',
            'customer_balance_amount',
            'base_gift_cards_amount',
            'gift_cards_amount',
            'reward_points_balance',
            'reward_currency_amount',
            'base_reward_currency_amount',
        ]);
    }
}
