<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Test\Unit\Model\Extensibility;

use Magento\CustomAttributeSerializable\Model\Extensibility\CustomAttributePathAppender;
use PHPUnit\Framework\TestCase;

/**
 * Test for @see CustomAttributePathAppender
 */
class CustomAttributePathAppenderTest extends TestCase
{
    /**
     * @var CustomAttributePathAppender
     */
    private CustomAttributePathAppender $appender;

    protected function setUp(): void
    {
        $this->appender = new CustomAttributePathAppender();
    }

    public function testAppendToRoot()
    {
        $array = [];
        $this->appender->append($array, 'root');

        $expected = [
            'custom_attributes' => [
                [
                    'attribute_code' => 'string',
                    'value' => 'mixed',
                ]
            ]
        ];

        self::assertEquals($expected, $array);
    }

    public function testAppendToNested()
    {
        $array = [
            'quote' => [
                'entity_id' => 'value1'
            ]
        ];
        $this->appender->append($array, 'quote');

        $expected = [
            'quote' => [
                'entity_id' => 'value1',
                'custom_attributes' => [
                    [
                        'attribute_code' => 'string',
                        'value' => 'mixed',
                    ]
                ]
            ]
        ];

        self::assertEquals($expected, $array);
    }

    public function testAppendToSpecificArrayPath()
    {
        $array = [
            'order' => [
                'items' => [
                    [
                        'id' => 'value1',
                        'entity_id' => 'value2'
                    ]
                ]
            ]
        ];
        $this->appender->append($array, 'order.items[]');

        $expected = [
            'order' => [
                'items' => [
                    [
                        'id' => 'value1',
                        'entity_id' => 'value2',
                        'custom_attributes' => [
                            [
                                'attribute_code' => 'string',
                                'value' => 'mixed',
                            ]
                        ]
                    ],
                ]
            ]
        ];

        self::assertEquals($expected, $array);
    }

    public function testAppendToNonExistentPath()
    {
        $array = [
            'order' => [
                'items' => []
            ]
        ];
        $this->appender->append($array, 'order.nonexistent');

        $expected = [
            'order' => [
                'items' => []
            ]
        ];

        self::assertEquals($expected, $array);
    }

    public function testAppendToNonExistentArrayPath()
    {
        $array = [
            'order' => [
                'items' => [
                    'id' => 'value1',
                    'entity_id' => 'value2'
                ]
            ]
        ];
        $this->appender->append($array, 'order.items[]');

        $expected = [
            'order' => [
                'items' => [
                    'id' => 'value1',
                    'entity_id' => 'value2'
                ]
            ]
        ];

        self::assertEquals($expected, $array);
    }

    public function testAppendToNonArrayElementPath()
    {
        $array = [
            'order' => [
                'items' => 'test'
            ]
        ];
        $expected = [
            'order' => [
                'items' => 'test'
            ]
        ];

        $this->appender->append($array, 'order.items[]');
        self::assertEquals($expected, $array);
        $this->appender->append($array, 'order.items');
        self::assertEquals($expected, $array);
    }
}
