<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Quote;

use Magento\Catalog\Model\Product;
use Magento\Framework\DataObject;
use Magento\Quote\Model\Quote\Item;
use Magento\Quote\Model\Quote\Item\Processor;

/**
 * Plugin to add custom attributes from buy request to the quote item
 */
class CartItemProcessorAfterPrepare
{
    /**
     * Adds custom attributes from buy request to the quote item
     *
     * @param Processor $subject
     * @param mixed $result
     * @param Item $item
     * @param DataObject $request
     * @param Product $candidate
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterPrepare(Processor $subject, $result, Item $item, DataObject $request, Product $candidate)
    {
        if (!empty($request->getData('custom_attributes')) && is_array($request->getData('custom_attributes'))) {
            $item->setCustomAttributes($request->getData('custom_attributes'));
        }
    }
}
