<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Setup;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\DB\Ddl\Table;

/**
 * Upgrade schema to add column for serializable custom attributes
 *
 * phpcs:ignoreFile
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @param AttributesConfigurationPool $configurationPool
     */
    public function __construct(private AttributesConfigurationPool $configurationPool)
    {
    }

    /**
     * @inheritDoc
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        foreach ($this->configurationPool->getAttributesConfiguration() as $data) {
            if (empty($data['table_name'])) {
                continue;
            }

            $installer->getConnection()->addColumn(
                $installer->getTable($data['table_name']),
                AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE,
                [
                    'type' => Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Serializable Custom Attributes',
                ]
            );
        }

        $installer->endSetup();
    }
}
