<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin;

use Magento\CustomAttributeSerializable\Model\AttributesConfigurationPool;
use Magento\CustomAttributeSerializable\Model\CustomAttributes\CustomAttributeConverter;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Model\AbstractModel;

/**
 * Copies custom attributes to a separate field that would be serialized
 */
class SerializableAttributesBeforeSave
{
    /**
     * @param CustomAttributeConverter $attributeConverter
     */
    public function __construct(private readonly CustomAttributeConverter $attributeConverter)
    {
    }

    /**
     * Copies custom attributes to a separate field that would be serialized
     *
     * @param AbstractResource $subject
     * @param AbstractModel $object
     */
    public function beforeSave(AbstractResource $subject, AbstractModel $object)
    {
        $customAttributes = $object->getCustomAttributes();
        if (is_null($customAttributes)) {
            $customAttributes = [];
        }
        if (!empty($object->getData(AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE))
            && empty($customAttributes)
        ) {
            return;
        }

        $object->setData(
            AttributesConfigurationPool::CUSTOM_ATTRIBUTES_SERIALIZABLE,
            $this->attributeConverter->toSerializableFormat($customAttributes)
        );
    }
}
