<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Plugin\Quote;

use Magento\Framework\DataObject;
use Magento\Quote\Api\Data\CartItemInterface;
use Magento\Quote\Model\Quote\Item\CartItemOptionsProcessor;

/**
 * Plugin to add custom attributes to the buy request

 */
class CartItemOptionsProcessorAfterGetBuyRequest
{
    /**
     * Adds custom attributes to the buy request
     *
     * @param CartItemOptionsProcessor $subject
     * @param DataObject|float $result
     * @param string $productType
     * @param CartItemInterface $cartItem
     * @return DataObject|mixed
     */
    public function afterGetBuyRequest(
        CartItemOptionsProcessor $subject,
        $result,
        $productType,
        CartItemInterface $cartItem
    ) {
        if (!empty($cartItem->getItemId())) {
            return $result;
        }

        if (!empty($cartItem->getCustomAttributes())) {
            if (!$result instanceof DataObject) {
                $result = new DataObject([
                    'qty' => $result,
                ]);
            }
            $result->setData('custom_attributes', $cartItem->getCustomAttributes());
        }

        return $result;
    }
}
