<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model;

/**
 * Pool of attributes configuration for models with the serializable custom attributes
 */
class AttributesConfigurationPool
{
    public const CUSTOM_ATTRIBUTES_SERIALIZABLE = 'custom_attributes_serializable';

    /**
     * @param array $attributesConfiguration
     */
    public function __construct(private readonly array $attributesConfiguration)
    {
    }

    /**
     * Returns the list of API interfaces for models with the serializable custom attributes
     *
     * @return array
     */
    public function getApiInterfaces(): array
    {
        return array_column($this->attributesConfiguration, 'api_interface');
    }

    /**
     * Returns the list of attributes configuration for models with the serializable custom attributes
     *
     * @return array
     */
    public function getAttributesConfiguration(): array
    {
        return $this->attributesConfiguration;
    }
}
